<?php
class StundenplanLogik{
	public static function init(){
		//noch nichts
	}
	
	public static function sendeLehrer($id){
		return Datenverwaltung::ladeLehrer($id)->getXML();
	}
	public static function empfangeLehrer($XML){
		$lehrer = new Lehrer();
		$lehrer->setId((int)$XML->id);
		$lehrer->setAnrede((string)$XML->anrede);
		$lehrer->setVorname((string)$XML->vorname);
		$lehrer->setNachname((string)$XML->nachname);
		return Datenverwaltung::speicherLehrer($lehrer);
	}
	public static function sendeLehrerListe(){
		$lehrerListe = Datenverwaltung::ladeLehrerListe();
		$xmlString = "<lehrerliste>";
		if($lehrerListe){
			foreach($lehrerListe as $lehrer){
				$xmlString.= $lehrer->getXML();
			}
		}
		$xmlString.= "</lehrerliste>";
		return $xmlString;
	}
	public static function sendeKlasse($id){
		return Datenverwaltung::ladeKlasse($id)->getXML();
	}
	public static function empfangeKlasse($XML){
		$klasse = new Klasse();
		$klasse->setId((int)$XML->id);
		$klasse->setName((string)$XML->name);
		$klasse->setSchuelerZahl((int)$XML->schuelerzahl);
		return Datenverwaltung::speicherKlasse($klasse);
	}
	public static function sendeKlassenListe(){
		$klassenListe = Datenverwaltung::ladeKlassenListe();
		$xmlString = "<klassenliste>";
		if($klassenListe){
			foreach($klassenListe as $klasse){
				$xmlString.= $klasse->getXML();
			}
		}
		$xmlString.= "</klassenliste>";
		return $xmlString;
	}
	public static function sendeFach($id){
		return Datenverwaltung::ladeFach($id)->getXML();
	}
	public static function empfangeFach($XML){
		$fach = new Fach();
		$fach->setId((int)$XML->id);
		$fach->setFarbe((string)$XML->farbe);
		$fach->setName((string)$XML->name);
		$fach->setBeschreibung((string)$XML->beschreibung);
		return Datenverwaltung::speicherFach($fach);
	}
	public static function sendeFaecherListe(){
		$faecherListe = Datenverwaltung::ladeFaecherListe();
		$xmlString = "<faecherliste>";
		if($faecherListe){
			foreach($faecherListe as $fach){
				$xmlString.= $fach->getXML();
			}
		}
		$xmlString.= "</faecherliste>";
		return $xmlString;
	}
	public static function sendeFaecherVonLehrer($id){
		$faecherListe = Datenverwaltung::ladeFaecherVonLehrer($id);
	
		$xmlString = "<faecherliste>";
		if($faecherListe){
			foreach($faecherListe as $fach){
				$xmlString.= $fach->getXML();
			}
		}
		$xmlString.= "</faecherliste>";
		return $xmlString;
	}
	public static function sendeRaum($id){
		return Datenverwaltung::ladeRaum($id)->getXML();
	}
	public static function empfangeRaum($XML){
		$raum = new Raum();
		$raum->setId((int)$XML->id);
		$raum->setKapazitaet((int)$XML->kapazitaet);
		$raum->setName((string)$XML->name);
		return Datenverwaltung::speicherRaum($raum);
	}
	public static function sendeRaumListe(){
		$raumListe = Datenverwaltung::ladeRaumListe();
		$xmlString = "<raumliste>";
		if($raumListe){
			foreach($raumListe as $raum){
				$xmlString.= $raum->getXML();
			}
		}
		$xmlString.= "</raumliste>";
		return $xmlString;
	}
	public static function sendeTermin($id){
		return Datenverwaltung::ladeTermin($id)->getXML();
	}
	public static function empfangeTermineVonKlasse($XML){
		$terminListe = array();
		foreach($XML->termin as $xmlTermin){
			$termin = new Termin();
			$termin->setId((int)$xmlTermin->id);
			$termin->setTag((int)$xmlTermin->tag);
			$termin->setBeginn((string)$xmlTermin->beginn);
			$termin->setEnde((string)$xmlTermin->ende);
			$klasse = new Klasse();
			$klasse->setId((int)$xmlTermin->klasse->id);
			$termin->setKlasse($klasse);
			$fach = new Fach();
			$fach->setId((int)$xmlTermin->fach->id);
			$termin->setFach($fach);
			$lehrer = new Lehrer();
			$lehrer->setId((int)$xmlTermin->lehrer->id);
			$termin->setLehrer($lehrer);
			$raum = new Raum();
			$raum->setId((int)$xmlTermin->raum->id);
			$termin->setRaum($raum);
			array_push($terminListe,$termin);
		}
		return Datenverwaltung::speicherTermineVonKlasse($terminListe);
	
	}
	public static function sendeStundenplanListe(){
		$stundenplanListe = Datenverwaltung::ladeStundenplanListe();
		$xmlString = "<stundenplanliste>";
		if($stundenplanListe){
			foreach($stundenplanListe as $klasse){
				$xmlString.= $klasse->getXML();
			}
		}
		$xmlString.= "</stundenplanliste>";
		return $xmlString;
	}
	public static function sendeTermineVonKlasse($id){
		$terminListe = Datenverwaltung::ladeTermineVonKlasse($id);
		$xmlString = "<terminliste>";
		if($terminListe){
			foreach($terminListe as $termin){
				$xmlString.= $termin->getXML();
			}
		}
		$xmlString.= "</terminliste>";
		return $xmlString;
	}
	public static function sendeError($request){
		return '<error>Fehler: kann Funktion '.$request.' nicht finden</error>';
	}
}
?>